(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      6386,        236]
NotebookOptionsPosition[      5344,        194]
NotebookOutlinePosition[      5724,        210]
CellTagsIndexPosition[      5681,        207]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"a2", "=", 
  RowBox[{
   RowBox[{"r0", "^", "2"}], "*", 
   RowBox[{"\[Omega]", "/", "D"}]}]}]], "Input",
 CellChangeTimes->{{3.5708170243148527`*^9, 3.570817039713733*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["r0", "2"], " ", "\[Omega]"}], "D"]], "Output",
 CellChangeTimes->{3.5708170417828517`*^9, 3.5708181243297696`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"a2", "=", "1"}], "\[IndentingNewLine]", 
 RowBox[{"a", "=", 
  RowBox[{"Sqrt", "[", "a2", "]"}]}]}], "Input",
 CellChangeTimes->{{3.5708170476711884`*^9, 3.570817070020467*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.570817072547611*^9, {3.5708181282079916`*^9, 3.5708181301991053`*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.570817072547611*^9, {3.5708181282079916`*^9, 3.570818130224107*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"P4", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"BesselJ", "[", 
     RowBox[{"1", ",", 
      RowBox[{"x", "*", "a"}]}], "]"}], "^", "2"}], "*", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"1", "/", 
        RowBox[{"x", "^", "2"}]}], "]"}], "/", "2"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"x", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"x", "^", "4"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "4"}], ")"}]}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5708170804540634`*^9, 3.5708172098894663`*^9}, {
  3.570817248853695*^9, 3.570817274196145*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"BesselJ", "[", 
     RowBox[{"1", ",", "x"}], "]"}], "2"], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox["1", 
       SuperscriptBox["x", "2"]], "]"}]}], "]"}]}], 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "4"]}], ")"}], 
    RowBox[{"1", "/", "4"}]]}]]], "Output",
 CellChangeTimes->{
  3.570817210912525*^9, {3.57081725365797*^9, 3.5708172765012765`*^9}, 
   3.570818133660303*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"P5", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"BesselJ", "[", 
     RowBox[{"1", ",", 
      RowBox[{"x", "*", "a"}]}], "]"}], "^", "2"}], "*", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"1", "/", 
        RowBox[{"x", "^", "2"}]}], "]"}], "/", "2"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"x", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"x", "^", "4"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "4"}], ")"}]}]}], ")"}]}]}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"BesselJ", "[", 
     RowBox[{"1", ",", "x"}], "]"}], "2"], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox["1", 
       SuperscriptBox["x", "2"]], "]"}]}], "]"}]}], 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "4"]}], ")"}], 
    RowBox[{"1", "/", "4"}]]}]]], "Output",
 CellChangeTimes->{3.5708181360734415`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[CapitalPhi]4", "=", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{"P4", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5708173100421953`*^9, 3.5708173537636957`*^9}, {
   3.5708174013634186`*^9, 3.5708174153962207`*^9}, 3.5708178661310015`*^9}],

Cell[BoxData["0.26652597275267165`"], "Output",
 CellChangeTimes->{3.5708173548927603`*^9, 3.570817417930366*^9, 
  3.5708178698002114`*^9, 3.570818140666704*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", "0.26652597275267165`", "]"}]], "Input",
 NumberMarks->False],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "2", ",", "6", ",", "6", ",", "5", ",", "2", ",", "5", ",", "9", ",", "7",
      ",", "2", ",", "7", ",", "5", ",", "2", ",", "6", ",", "7", ",", "1", 
     ",", "6"}], "}"}], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.5708181769657803`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[CapitalPhi]5", "=", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{"P5", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5708181629469786`*^9, 3.570818184865232*^9}}],

Cell[BoxData["0.09130913372012318`"], "Output",
 CellChangeTimes->{3.5708182278306894`*^9}]
}, Open  ]]
},
WindowSize->{1938, 918},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
Magnification->1.6000001430511475`,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 197, 5, 47, "Input"],
Cell[779, 29, 172, 4, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[988, 38, 202, 4, 77, "Input"],
Cell[1193, 44, 123, 2, 47, "Output"],
Cell[1319, 48, 121, 2, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1477, 55, 703, 22, 47, "Input"],
Cell[2183, 79, 598, 20, 92, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2818, 104, 584, 20, 47, "Input"],
Cell[3405, 126, 524, 18, 92, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3966, 149, 340, 7, 47, "Input"],
Cell[4309, 158, 162, 2, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4508, 165, 103, 2, 47, "Input"],
Cell[4614, 169, 323, 8, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4974, 182, 260, 6, 47, "Input"],
Cell[5237, 190, 91, 1, 80, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
